<?php
// app/Livewire/Admin/Transmittal/CreateTransmittalTemplate.php

namespace App\Livewire\Admin\Transmittal;

use Livewire\Attributes\Layout;
use Livewire\Component;
use App\Models\TransmittalTemplate;
use App\Models\User;

#[Layout('admin.master')]
class CreateTransmittalTemplate extends Component
{
    public $title, $purpose, $sender_id, $description;
    public $senders;

    public function mount()
    {
        $this->senders = User::orderBy('name')->get(['id','name']);
    }

    public function save()
    {
        $data = $this->validate([
            'title'       => 'required|string|max:100',
            'purpose'     => 'nullable|string|max:100',
            'sender_id'   => 'nullable|exists:users,id',
            'description' => 'nullable|string|max:1000',
        ]);

        TransmittalTemplate::create($data);

        session()->flash('success', 'قالب با موفقیت ذخیره شد.');
        return redirect()->route('admin.transmittal.templates.list'); // مطمئن شو این روت موجوده
    }

    public function render()
    {
        return view('livewire.admin.transmittal.create-transmittal-template');
    }
}
