<?php

namespace App\Livewire\Admin\Transmittal;

use Livewire\Attributes\Layout;
use Livewire\Component;
use App\Models\Transmittal;

class ShowTransmittal extends Component
{
    public Transmittal $trans;

    public function mount(int $id)
    {
        // بارگذاری کامل روابط مورد نیاز
        $this->trans = Transmittal::with([
            'project:id,name,code',
            'sender:id,name',
            'receiver:id,name',
            'recipients.user:id,name',
            'documents.masterDocument:id,document_number,title',
            'attachments:id,transmittal_id,file_name,file_path,size',
            // اگر لاگ دارید این را فعال کنید
            'logs.user:id,name',
        ])->findOrFail($id);
    }

    #[Layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.transmittal.show-transmittal', [
            'trans' => $this->trans,
        ]);
    }
}
