<?php

namespace App\Livewire\Admin\Users\Positions;

use App\Models\User;
use App\Models\UserPosition;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;

class EditPosition extends Component
{
    public $user_id;

    #[Validate('required|string|max:100', message: 'لطفاً سمت کاربر را وارد کنید')]
    public $position = '';

    public $users = [];
    public $userPosition;
    public $positionId;
    public $selectedUserObject;


    public function mount($id)
    {
        $this->positionId = $id;
        $this->userPosition = UserPosition::with('user')->findOrFail($id);

        $this->user_id = $this->userPosition->user_id;
        $this->position = $this->userPosition->position;

        // 💡 لود کردن شیء کامل کاربر برای نمایش
        $this->selectedUserObject = $this->userPosition->user;

        // 💡 لود کردن همه کاربران برای Dropdown (اگرچه در حالت ویرایش کمتر تغییر می‌کند)
        $this->users = User::orderBy('name')->get(['id', 'name', 'email']);
    }

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function updateUserPosition()
    {
        $this->validate([
            'user_id' => 'required|exists:users,id',
            'position' => 'required|string|max:100',
        ]);

        try {
            $this->userPosition->update([
                'user_id' => $this->user_id,
                'position' => $this->position
            ]);

            $userName = $this->selectedUserObject->name ?? 'کاربر';

            session()->flash('message', "سمت {$userName} با موفقیت به \"{$this->position}\" بروزرسانی شد.");

            return redirect()->route('admin.user.position'); // ریدایرکت به لیست اصلی
        } catch (\Exception $e) {
            session()->flash('error', 'خطا در بروزرسانی اطلاعات. لطفاً دوباره تلاش کنید.');
        }
    }

    public function cancel()
    {
        return redirect()->route('admin.user.position'); // ریدایرکت به لیست اصلی
    }


    public function render()
    {
        return view('livewire.admin.users.positions.edit-position')->layout('admin.master');
    }
}
