<?php

namespace App\Livewire\Admin\Users;

use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Illuminate\Support\Facades\Hash;

#[Layout('admin.master')]
class UserProfile extends Component
{
    public User $user;

    // تغییر رمز داخل همین صفحه
    public bool $showPasswordModal = false;
    public $newPassword, $newPasswordConfirmation;

    public function mount(User $user)
    {
        // eager load های سبک
        $user->load([
            'department:id,name,company_id',
            'department.company:id,name',
        ]);
        $this->user = $user;
    }

    public function openPasswordModal()
    {
        $this->resetErrorBag();
        $this->newPassword = $this->newPasswordConfirmation = '';
        $this->showPasswordModal = true;
    }

    public function closePasswordModal()
    {
        $this->showPasswordModal = false;
        $this->reset(['newPassword','newPasswordConfirmation']);
        $this->resetErrorBag();
    }

    public function updatePassword()
    {
        $this->validate([
            'newPassword' => ['required','min:6'],
            'newPasswordConfirmation' => ['required','same:newPassword'],
        ], [
            'newPassword.required' => 'رمز عبور جدید الزامی است.',
            'newPassword.min' => 'حداقل 6 کاراکتر.',
            'newPasswordConfirmation.required' => 'تکرار رمز الزامی است.',
            'newPasswordConfirmation.same' => 'تکرار با رمز جدید یکسان نیست.',
        ]);

        $this->user->update(['password' => Hash::make($this->newPassword)]);
        session()->flash('success', 'رمز عبور با موفقیت تغییر کرد.');
        $this->closePasswordModal();
    }

    public function render()
    {
        return view('livewire.admin.users.user-profile');
    }
}
