<?php

namespace App\Livewire\Admin\Users;

use App\Models\Permission;
use App\Models\Project;
use App\Models\Role;
use App\Models\User;
use App\Models\UserPermission;
use App\Models\UserRole;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;

class UserRoleManagement extends Component
{
    use WithFileUploads;

    public $users;
    public $roles;
    public $projects;
    public $permissions;
    public $selectedUser;
    public $selectedRole;
    public $selectedProject;
    public $selectedPermissions=[];

    public function mount()
    {
        $this->users = User::all();
        $this->roles = Role::all();
        $this->projects = Project::all();
        $this->permissions = Permission::all();

    }
    public function assignRole()
    {
        $userRole = UserRole::create([
            'user_id' => $this->selectedUser,
            'role_id' => $this->selectedRole,
            'project_id' => $this->selectedProject,
            ]);

        foreach ($this->selectedPermissions as $permission)
        {
            UserPermission::create([
                'user_id' => $this->selectedUser,
                'permission_id' => $permission,
                'project_id' => $this->selectedProject,
                ]); }
        session()->flash('message', 'Role and permissions assigned successfully.'); }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.users.user-role-management');
    }
}
