<div class="card border-0 shadow-sm rounded-4 mb-4 overflow-hidden">
    <div class="card-header bg-white p-0 border-bottom">
        <ul class="nav nav-tabs nav-fill border-0" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active text-dark fw-semibold py-3 px-4"
                   data-bs-toggle="tab" href="#personal" role="tab">
                    <i class="fas fa-user-circle me-1"></i> مشخصات شخصی
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link text-secondary fw-semibold py-3 px-4"
                   data-bs-toggle="tab" href="#advanced" role="tab">
                    <i class="fas fa-cogs me-1"></i> تنظیمات پیشرفته
                </a>
            </li>
        </ul>
    </div>

    <div class="card-body p-4">
        <form wire:submit.prevent="saveUser">
            <div class="tab-content">
                {{-- Tab 1 --}}
                <div class="tab-pane fade show active" id="personal" role="tabpanel">
                    <div class="row g-4">
                        <div class="col-lg-6">
                            <div class="row g-3">
                                <div class="col-12">
                                    <label class="form-label fw-semibold">نام کامل <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-lg @error('name') is-invalid @enderror" wire:model.defer="name">
                                    @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">ایمیل <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control form-control-lg @error('email') is-invalid @enderror" wire:model.defer="email">
                                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">موبایل <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control form-control-lg @error('mobile') is-invalid @enderror" wire:model.defer="mobile" placeholder="مثلاً 0912xxxxxxx">
                                    @error('mobile') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">کد ملی <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-lg @error('ncode') is-invalid @enderror" wire:model.defer="ncode">
                                    @error('ncode') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="row g-3">
                                <div class="col-12">
                                    <label class="form-label fw-semibold">شرکت</label>
                                    <select class="form-select form-select-lg" wire:model.live="company_id">
                                        <option value="">انتخاب کنید...</option>
                                        @foreach($companies as $company)
                                        <option value="{{ $company->id }}">{{ $company->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">دپارتمان</label>
                                    <select class="form-select form-select-lg @error('department_id') is-invalid @enderror"
                                            wire:model.defer="department_id" @disabled(!$company_id)>
                                        <option value="">انتخاب کنید...</option>
                                        @foreach($departments as $dep)
                                        <option value="{{ $dep->id }}">{{ $dep->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('department_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-semibold">مدرک تحصیلی</label>
                                    <select class="form-select form-select-lg" wire:model.defer="degree">
                                        <option value="">انتخاب کنید...</option>
                                        @foreach($degrees as $deg)
                                        <option value="{{ $deg }}">{{ $deg }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            {{-- تصاویر --}}
                            <div class="row g-3 mt-3">
                                <div class="col-6">
                                    <label class="form-label fw-semibold">تصویر پروفایل</label>
                                    <input type="file" class="form-control" wire:model="image" accept="image/*">
                                    <div wire:loading wire:target="image" class="small text-muted mt-1">در حال بارگذاری...</div>
                                    @if($image)
                                    <img src="{{ $image->temporaryUrl() }}" class="rounded-circle border mt-2" width="70" height="70" style="object-fit: cover;">
                                    @elseif($currentImage)
                                    <img src="{{ Storage::disk('users')->url($currentImage) }}" class="rounded-circle border mt-2" width="70" height="70" style="object-fit: cover;">
                                    @else
                                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center text-muted mt-2" style="width:70px; height:70px;">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    @endif
                                    @error('image') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-6">
                                    <label class="form-label fw-semibold">امضا</label>
                                    <input type="file" class="form-control" wire:model="sign" accept="image/*">
                                    <div wire:loading wire:target="sign" class="small text-muted mt-1">در حال بارگذاری...</div>
                                    @if($sign)
                                    <img src="{{ $sign->temporaryUrl() }}" class="border mt-2" width="100" height="40" style="object-fit: cover;">
                                    @elseif($currentSign)
                                    <img src="{{ Storage::disk('users')->url($currentSign) }}" class="border mt-2" width="100" height="40" style="object-fit: cover;">
                                    @else
                                    <div class="bg-light border d-flex align-items-center justify-content-center text-muted mt-2" style="width:100px; height:40px;">
                                        <small>امضا</small>
                                    </div>
                                    @endif
                                    @error('sign') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Tab 2 --}}
                <div class="tab-pane fade" id="advanced" role="tabpanel">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">جنسیت</label>
                            <div class="d-flex gap-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" value="male" id="male" wire:model.defer="gender">
                                    <label class="form-check-label" for="male">مرد</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" value="female" id="female" wire:model.defer="gender">
                                    <label class="form-check-label" for="female">زن</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">نقش کاربر</label>
                            <select class="form-select form-select-lg" wire:model.defer="role">
                                <option value="">همه نقش‌ها</option>
                                <option value="admin">مدیر سیستم</option>
                                <option value="manager">مدیر پروژه</option>
                                <option value="editor">ویرایشگر</option>
                                <option value="user">کاربر عادی</option>
                                <option value="guest">مهمان</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">وضعیت</label>
                            <select class="form-select form-select-lg" wire:model.defer="status">
                                <option value="">همه وضعیت‌ها</option>
                                <option value="active">فعال</option>
                                <option value="inactive">غیرفعال</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            @if(!$editMode)
                            <div class="mb-3">
                                <label class="form-label fw-semibold">رمز عبور <span class="text-danger">*</span></label>
                                <input type="password" class="form-control form-control-lg @error('password') is-invalid @enderror" wire:model.defer="password">
                                @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">تکرار رمز عبور</label>
                                <input type="password" class="form-control form-control-lg" wire:model.defer="password_confirmation">
                                @error('password_confirmation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            @else
                            <div class="alert alert-light border p-3 small">
                                <i class="fas fa-info-circle me-1"></i>
                                برای تغییر رمز، فیلدهای زیر را پر کنید.
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">رمز عبور جدید (اختیاری)</label>
                                <input type="password" class="form-control form-control-lg" wire:model.defer="password">
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">تکرار رمز عبور جدید</label>
                                <input type="password" class="form-control form-control-lg" wire:model.defer="password_confirmation">
                                @error('password_confirmation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-5 d-flex justify-content-end gap-3">
                @if($editMode)
                <button type="button" wire:click="cancelEdit" class="btn btn-outline-secondary px-4 py-2">
                    <i class="fas fa-times"></i> انصراف
                </button>
                <button type="submit" class="btn btn-primary px-4 py-2" wire:loading.attr="disabled">
                    <span wire:loading.remove><i class="fas fa-save"></i> ذخیره تغییرات</span>
                    <span wire:loading><i class="fas fa-spinner fa-spin"></i> در حال ذخیره...</span>
                </button>
                @else
                <button type="button" wire:click="resetForm" class="btn btn-outline-warning px-4 py-2">
                    <i class="fas fa-undo"></i> پاک کردن
                </button>
                <button type="submit" class="btn btn-success px-4 py-2" wire:loading.attr="disabled">
                    <span wire:loading.remove><i class="fas fa-plus-circle"></i> ایجاد کاربر</span>
                    <span wire:loading><i class="fas fa-spinner fa-spin"></i> در حال ایجاد...</span>
                </button>
                @endif
            </div>
        </form>
    </div>
</div>
