<?php

// app/Livewire/Auth/Logout.php

namespace App\Livewire\Auth;

use App\Livewire\Actions\Logout as LogoutAction; // فضای نام کلاس Logout خودت
use Livewire\Component;

class Logout extends Component
{
    public function logout(LogoutAction $logoutAction)
    {
        $logoutAction(); // فراخوانی کلاس Logout

        // بعد از لاگ‌اوت، هدایت کاربر به صفحه اصلی یا صفحه لاگین
        // توجه: اگر route 'home' نداری، از '/' یا route('login') استفاده کن
        // اینجا فرض می‌کنیم route 'home' وجود داره
        return $this->redirect(route('home'), true);
    }

    public function render()
    {
        // این کامپوننت فقط برای انجام عمل لاگ‌اوت استفاده می‌شه، نیازی به نمایش ویو نداره
        // ولی برای اینکه بشه یه دکمه یا لینک براش نوشت، یه ویو خالی یا فقط یه دکمه اضافه می‌کنیم
        return view('livewire.auth.logout');
    }
}
