<?php


namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\Project;
use App\Models\Post;
use Illuminate\Support\Facades\Auth;

class Dashboard extends Component
{
    public $user;
    public $data = []; // برای نگهداری آمار کلیدی

    public function mount()
    {
        $this->user = Auth::user();
        $this->loadDashboardData();
    }

    protected function loadDashboardData()
    {
        // آمار مرتبط با کاربر
        $this->data['activeTasksCount'] = $this->user->assignedTasks()->where('status', '!=', 'completed')->count();
        $this->data['newLettersCount'] = $this->user->receivedLetters()->wherePivot('read_at', null)->count();
        $this->data['newAnnouncementsCount'] = $this->user->receivedAnnouncements()->wherePivot('read_at', null)->count();

        // آمار مرتبط با مدیریت پروژه (اگر مدیر باشد)
        $this->data['managedProjectsCount'] = $this->user->managedProjects()->count();

        // آمار کلی سیستم (فقط برای مدیران)
        if ($this->user->isAdmin()) {
            $this->data['totalProjects'] = Project::count();
        }

        // وبلاگ (آخرین پست‌ها)
        $this->data['latestPosts'] = Post::latest()->take(3)->get();

        // توجه: برای درخواست‌های مالی (PurchaseRequests) باید مدل مربوطه وجود داشته باشد.
        // $this->data['pendingPurchases'] = $this->user->purchaseRequests()->where('status', 'pending')->count();
    }

    public function render()
    {
        return view('livewire.dashboard')->layout('admin.master');
    }
}
