<?php
namespace App\Livewire\User;

use App\Models\Task;
use App\Models\Project;
use App\Models\PurchaseRequest;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Dashboard extends Component
{
    public $activeProjects;
    public $pendingProjects;
    public $totalLetters;
    public $readLetters;
    public $newLetters;
    public $totalRequests;
    public $approvedRequests;
    public $pendingRequests;

    // --- متغیرهای جدید برای نامه‌های ارسالی ---
    public $totalSentLetters;
    public $sentCompletedLetters;
    public $sentPendingLetters;
    // ------------------------------------------

    public $recentActivities = [];
    public $myTasks = [];
    public $projectTasks = [];
    public $firstProjectId = null;

    // فایل: app/Livewire/User/Dashboard.php (فقط تابع mount() را جایگزین کنید)

    public function mount()
    {
        $user = Auth::user();

        // آمار پروژه‌ها (بدون تغییر)
        $userProjects = $user->projects()->get();
        $this->activeProjects = $userProjects->where('pivot.status', 'active')->count();
        $this->pendingProjects = $userProjects->where('pivot.status', 'pending')->count();
        $this->firstProjectId = optional($userProjects->first())->id ?? 1;

        // آمار نامه‌های دریافتی (Letters Received)
        $this->totalLetters = $user->receivedLetters()->count();
        $this->readLetters = $user->receivedLetters()->where('status', 'viewed')->count();
        $this->newLetters = $user->receivedLetters()->where('status', 'pending')->count();

        // ----------------------------------------------------
        // --- منطق جدید و اصلاح شده برای نامه‌های ارسالی ---
        // ----------------------------------------------------

        // 1. کل نامه‌هایی که کاربر ارسال کرده است (به عنوان فرستنده)
        $this->totalSentLetters = $user->sentLetters()->count();

        // 2. شمارش ارجاعات تکمیل/در انتظار برای تمام نامه‌های ارسالی
        $sentLetterIds = $user->sentLetters()->pluck('id');

        // فرض می‌کنیم مدل Referral وجود دارد و به letter_id مرتبط است.
        $this->sentCompletedLetters = \App\Models\Referral::whereIn('letter_id', $sentLetterIds)
            ->where('status', 'completed')
            ->count();

        $this->sentPendingLetters = \App\Models\Referral::whereIn('letter_id', $sentLetterIds)
            ->where('status', 'pending')
            ->count();

        // ----------------------------------------------------
        // --- پایان منطق اصلاح شده ---
        // ----------------------------------------------------

        // درخواست‌های خرید (بدون تغییر)
        $myPurchaseRequests = PurchaseRequest::where('user_id', $user->id)->get();
        $this->totalRequests = $myPurchaseRequests->count();
        $this->approvedRequests = $myPurchaseRequests->where('status', 'approved')->count();
        $this->pendingRequests = $myPurchaseRequests->where('status', 'pending')->count();

        // تسک‌ها (بدون تغییر)
        $this->myTasks = Task::where('assigned_to', $user->id)
            ->with('project')
            ->latest('due_date')
            ->take(5)
            ->get();

        $projectIds = $user->projects()->pluck('projects.id')->all();
        $this->projectTasks = Task::whereIn('project_id', $projectIds)
            ->with('project', 'assignedUser')
            ->where('assigned_to', '!=', $user->id)
            ->latest('due_date')
            ->take(5)
            ->get();

        $this->recentActivities = [
            ['icon' => 'briefcase', 'title' => 'پروژه جدید اضافه شد', 'time' => '10 دقیقه پیش'],
            ['icon' => 'mail', 'title' => 'نامه جدید دریافت شد', 'time' => '1 ساعت پیش'],
        ];
    }

    public function render()
    {
        return view('livewire.user.dashboard')->layout('admin.master'); // تغییر layout به 'admin.master' در این سطح کامپوننت ممکن نیست، پس حذف شد.
    }
}
