<?php

namespace App\Livewire\User;

use App\Models\Post;
use App\Models\BlogCategory;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('admin.master')]
class Posts extends Component
{
    use WithPagination;

    // برای pagination.custom-modern
    protected string $paginationTheme = 'bootstrap-5';

    #[Url(as: 'q', except: '')]
    public string $search = '';

    // فیلتر دسته‌بندی (بر اساس id دسته)
    #[Url(as: 'cat', except: '')]
    public string $category = ''; // خالی = همه دسته‌ها

    public function updatingSearch(): void
    {
        $this->resetPage();
    }

    public function updatingCategory(): void
    {
        $this->resetPage();
    }

    public function render()
    {
        // دسته‌بندی‌های فعال + تعداد پست‌های منتشرشده
        $categories = BlogCategory::query()
            ->where('status', true)
            ->withCount([
                'posts as published_posts_count' => function ($q) {
                    $q->where('is_published', true);
                },
            ])
            ->orderBy('name')
            ->get();

        $posts = Post::query()
            ->where('is_published', true)
            ->with(['category', 'author'])
            ->when($this->category !== '', function ($q) {
                $q->where('blog_category_id', (int) $this->category);
            })
            ->when($this->search !== '', function ($q) {
                $term = trim($this->search);
                $q->where(function ($qq) use ($term) {
                    $qq->where('title', 'like', "%{$term}%")
                        ->orWhere('content', 'like', "%{$term}%");
                });
            })
            ->latest()
            ->paginate(8);

        return view('livewire.user.posts', [
            'posts'      => $posts,
            'categories' => $categories,
            'isAdmin'    => Auth::check() && method_exists(Auth::user(), 'isAdmin') && Auth::user()->isAdmin(),
        ]);
    }
}
