<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Announcement extends Model
{
    protected $fillable = ['sender_id','title','content','file'];

    public function sender(): BelongsTo
    {
        return $this->belongsTo(User::class, 'sender_id');
    }

//    public function recipients(): BelongsToMany
//    {
//        return $this->belongsToMany(User::class, 'announcement_recipients')
//            ->withPivot('read_at')
//            ->withTimestamps();
//    }

    public function recipients(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'announcement_recipients')
            ->using(AnnouncementRecipient::class) // 👈 مهم: مشخص کردن Pivot Model
            ->withPivot('read_at')
            ->withTimestamps();
    }

    /** ✅ اضافه شد: رابطهٔ پیوست‌ها */
    public function attachments(): HasMany
    {
        return $this->hasMany(AnnouncementAttachment::class);
    }

    /** مارک به‌عنوان خوانده برای یک کاربر */
    public function markAsRead($userId): void
    {
        $this->recipients()->updateExistingPivot($userId, ['read_at' => now()]);
    }

    /** مارک به‌عنوان نخوانده */
    public function markAsUnread($userId): void
    {
        $this->recipients()->updateExistingPivot($userId, ['read_at' => null]);
    }

    /** آیا توسط کاربر خوانده شده؟ */
    public function isReadBy($userId): bool
    {
        return $this->recipients()
            ->where('user_id', $userId)
            ->whereNotNull('read_at')
            ->exists();
    }
}
