<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ApprovalRule extends Model
{
    protected $fillable = [
        'project_id',
        'name',
        'type',
        'amount_min',
        'amount_max',
        'product_type','is_default',
        'priority',
    ];

    public function approvers(): HasMany
    {
        return $this->hasMany(Approver::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }
}
