<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
// app/Models/ApprovalStep.php
class ApprovalStep extends Model
{
    // اگر constants ندارید، اضافه کنید:
    public const ST_PENDING  = 'pending';
    public const ST_APPROVED = 'approved';
    public const ST_REJECTED = 'rejected';
    public const ST_SKIPPED  = 'skipped';

    protected $fillable = [
        'request_id','step_order','approver_id','delegated_to',
        'status','role_hint','decided_at','decided_by','decision_note',
    ];

    protected $casts = [
        'decided_at' => 'datetime',
    ];

    public function approver() { return $this->belongsTo(User::class, 'approver_id'); }
}
