<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AttendanceApprovalRule extends Model
{
    protected $table = 'attendance_approval_rules';

    protected $fillable = [
        'name',
        'company_id',
        'type',
        'leave_type',
        'project_id',
        'company_id',
        'department_id',
        'min_duration_hours',
        'max_duration_hours',
        'step_order',
        'approvers',
        'is_active',
    ];

    protected $casts = [
        'approvers' => 'array', // به صورت خودکار json را به آرایه تبدیل می‌کند
        'is_active' => 'boolean',
        'min_duration_hours' => 'integer',
        'max_duration_hours' => 'integer',
        'step_order' => 'integer',
    ];

    // روابط
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    // ✅ اضافه کردن روابط
    public function company()
    {
        return $this->belongsTo(Company::class);
    }


}
