<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class BlogCategory extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * نام جدولی که مدل با آن در ارتباط است.
     * اگر نام جدول شما 'categories' است، این خط را حذف کنید یا به 'categories' تغییر دهید.
     * @var string
     */
    protected $table = 'blog_categories';

    /**
     * ستون‌هایی که قابلیت تخصیص انبوه (Mass Assignable) دارند.
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'slug',
        'description',
        'status', // مثلاً وضعیت فعال/غیرفعال
    ];

    /**
     * ستون‌هایی که به صورت آرایه یا JSON باید تغییر نوع یابند.
     * @var array<string, string>
     */
    protected $casts = [
        'status' => 'boolean',
    ];

    // --- روابط (Relationships) ---

    /**
     * یک دسته‌بندی می‌تواند پست‌های زیادی داشته باشد.
     * فرض می‌کنیم نام مدل پست شما 'Post' است.
     * @return HasMany
     */
    public function posts(): HasMany
    {
        // فرض بر این است که در جدول 'posts' ستونی به نام 'blog_category_id' برای کلید خارجی وجود دارد.
        return $this->hasMany(Post::class, 'blog_category_id');
    }
}
