<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo; // ✅ جدید: برای Type Hinting

class CallReminder extends Model
{
    protected $fillable = [
        'user_id',          // شناسه کاربر مالک یادآوری
        'contact_id',       // شناسه مخاطبی که یادآوری برای اوست
        'reminder_time',    // زمان یادآوری
        'message',          // پیام یادآوری
    ];

    // 🔄 Type Casting
    protected $casts = [
        // ✅ حتماً reminder_time را به Carbon کست کنید
        'reminder_time' => 'datetime',
    ];

    // --- 🔗 Relations ---

    /**
     * ارتباط با مخاطب
     * فرض می‌کنیم کلید خارجی در جدول call_reminders، 'contact_id' است.
     * @return BelongsTo
     */
    public function contact(): BelongsTo
    {
        // پارامتر دوم (contact_id) نام کلید خارجی در جدول CallReminders است.
        return $this->belongsTo(Contact::class, 'contact_id');
    }

    /**
     * ارتباط با کاربر مالک یادآوری
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        // پارامتر دوم (user_id) نام کلید خارجی در جدول CallReminders است.
        return $this->belongsTo(User::class, 'user_id');
    }
}
