<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Company extends Model
{
    protected $fillable = [
        'name',
        'fax',
        'tel',
        'image',
        'address', // ✨ فیلد جدید آدرس
    ];

    public function projectRoles(): HasMany
    {
        return $this->hasMany(ProjectRole::class);
    }

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    // پروژه‌هایی که این شرکت مشتری اصلی است
    public function projectsAsMainClient(): HasMany
    {
        return $this->hasMany(ProjectDetail::class, 'main_client_id');
    }

    // پروژه‌هایی که این شرکت پیمانکار است
    public function projectsAsContractor(): HasMany
    {
        return $this->hasMany(ProjectDetail::class, 'contractor_id');
    }

    public function departments(): HasMany
    {
        return $this->hasMany(Department::class);
    }

    // ✨ رابطه: سربرگ‌های مجاز برای این شرکت
    public function letterForms(): BelongsToMany
    {
        return $this->belongsToMany(LetterForm::class, 'company_letter_form', 'company_id', 'letter_form_id')
            ->withTimestamps();
    }
}
