<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CostCenter extends Model
{
    protected $fillable = [
        'name',
        'code',
        'description',
        'is_active'
    ];

    /**
     * رابطه با درخواست‌های خرید
     */
    public function purchaseRequests(): HasMany
    {
        return $this->hasMany(PurchaseRequest::class, 'cost_center_id');
    }

    /**
     * می‌توانید رابطه‌های دیگری به پروژه‌ها یا دپارتمان‌ها نیز اینجا اضافه کنید.
     */
}
