<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    protected $fillable = [
        'company_id', 'parent_id', 'manager_id', 'name', 'code',
        'status', 'color', 'sort_order', 'description',
    ];

    /* روابط اصلی */
    public function company()     { return $this->belongsTo(Company::class); }
    public function parent()      { return $this->belongsTo(Department::class, 'parent_id'); }
    public function children()    { return $this->hasMany(Department::class, 'parent_id'); }
    public function manager()     { return $this->belongsTo(User::class, 'manager_id'); }
    public function users()       { return $this->hasMany(User::class); }

    /* اسکوپ‌های کاربردی */
    public function scopeActive($q)     { return $q->where('status','active'); }
    public function scopeForCompany($q, $companyId) { return $q->where('company_id',$companyId); }

    /* کمکی‌ها */
    public function headcount(): int
    {
        return $this->users()->count();
    }
}
