<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DocumentRevision extends Model
{
    protected $fillable = [
        'master_document_id',  // ارتباط با مستند اصلی
        'revision_type',       // نوع نسخه (مثلاً اصلاحی، موقت، نهایی)
        'transmittal_number',  // شماره ترنسمیتال
        'revision',            // شماره نسخه (مثل Rev.01)
        'status',              // وضعیت نسخه (مثلاً تایید شده، در حال بررسی)
        'date',                // تاریخ نسخه
        'remark',              // یادداشت‌ها و توضیحات

        'poi_type', // ✅ اضافه شد

        'file_path',           // مسیر فایل نسخه
        'file_name',           // نام فایل نسخه
    ];

    // ✅ لیست POI Types
    public const POI_TYPES = [
        'IFC' => 'IFC - Issued for Construction',
        'IFA' => 'IFA - Issued for Approval',
        'AFC' => 'AFC - Approved for Construction',
        'IFI' => 'IFI - Issued for Information',
        'Rec' => 'Received',


    ];

    public function masterDocument()
    {
        return $this->belongsTo(MasterDocument::class);
    }

    public function files()
    {
        return $this->morphMany(DocumentFile::class, 'attachable');
    }


}
