<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Morilog\Jalali\Jalalian;

class FileActivity extends Model
{
    protected $fillable = [
        'project_file_id',
        'user_id',
        'action_type',
        'details',
        'old_values',
        'new_values',
    ];

    protected $casts = [
        'old_values' => 'json',
        'new_values' => 'json',
    ];

    // رابطه با فایل
    public function projectFile()
    {
        return $this->belongsTo(ProjectFile::class);
    }

    // رابطه با کاربر عامل
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // متد کمکی برای نمایش تاریخ شمسی
    public function getCreatedAtJalaliAttribute()
    {
        return Jalalian::fromDateTime($this->created_at)->format('Y/m/d H:i');
    }
}
