<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Folder extends Model
{
    protected $fillable = [
        'name',
        'parent_id',
        'section_id',
    ];

    // ارتباط با بخش (Section)
    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    // ارتباط با پوشه والد (برای پوشه‌های تو در تو)
    public function parent()
    {
        return $this->belongsTo(Folder::class, 'parent_id');
    }

    // ارتباط با زیرپوشه‌ها
    public function children()
    {
        return $this->hasMany(Folder::class, 'parent_id');
    }

    // ارتباط با فایل‌ها
    public function files()
    {
        return $this->hasMany(ProjectFile::class);
    }
}
