<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InsuranceAttachment extends Model
{
    use HasFactory;

    // 💡 نام جدول (به صورت جمع و snake_case)
    protected $table = 'insurance_attachments';

    protected $fillable = [
        'project_insurance_id', // 💡 کلید خارجی
        'file_path',
        'file_name',
        'file_type',
        'file_size',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * رابطه با قرارداد بیمه والد
     */
    public function insurance(): BelongsTo
    {
        // 🛑 FIX: لاراول به طور پیش فرض 'project_insurance_id' را انتظار دارد.
        return $this->belongsTo(ProjectInsurance::class, 'project_insurance_id');
    }
}
