<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LeaveMissionDetail extends Model
{
    protected $table = 'leave_mission_details';

    protected $fillable = [
        'request_id',
        'leave_type',
        'mission_city','mission_address','mission_purpose',
        'start_datetime','end_datetime',
        'duration_hours','is_full_day','overlap_ok',
    ];

    protected $casts = [
        'start_datetime' => 'datetime',
        'end_datetime'   => 'datetime',
        'is_full_day'    => 'boolean',
        'overlap_ok'     => 'boolean',
    ];

    public function request(){ return $this->belongsTo(LeaveMissionRequest::class, 'request_id'); }
}
