<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class LeaveMissionRequest extends Model
{
    protected $table = 'leave_mission_requests';

    protected $fillable = [
        'user_id','company_id','department_id',
        'type','status','current_step',
        'title','description','attachments_count',
        'submitted_at','decided_at','project_id',

    ];

    protected $casts = [
        'submitted_at' => 'datetime',
        'decided_at'   => 'datetime',
    ];


    // انواع و وضعیت‌ها
    const TYPE_LEAVE   = 'leave';
    const TYPE_MISSION = 'mission';

    const ST_DRAFT    = 'draft';
    const ST_PENDING  = 'pending';
    const ST_APPROVED = 'approved';
    const ST_REJECTED = 'rejected';
    const ST_CANCELED = 'canceled';

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    // روابط
    public function user(){ return $this->belongsTo(User::class); }
    public function department(){ return $this->belongsTo(Department::class); }
    public function details(){ return $this->hasOne(LeaveMissionDetail::class, 'request_id'); }
    public function approvals(){ return $this->hasMany(ApprovalStep::class, 'request_id')->orderBy('step_order'); }

    // اسکوپ‌ها
    public function scopeMine(Builder $q){ return $q->where('user_id', auth()->id()); }

    public function scopePendingFor(Builder $q, int $approverId){
        return $q->where('status', self::ST_PENDING)
            ->whereHas('approvals', fn($qq)=>$qq->where('approver_id',$approverId)->where('status', ApprovalStep::ST_PENDING));
    }

    public function currentApproval()
    {
        return $this->approvals->firstWhere('step_order', $this->current_step);
    }
}
