<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LetterForm extends Model
{
    protected $fillable = ['name', 'background', 'is_global']; // ✨ افزودن is_global

    public function letters(): HasMany
    {
        return $this->hasMany(Letter::class, 'background_id');
    }

    // ✨ رابطه: شرکت‌هایی که این قالب برای آن‌ها مجاز است
    public function companies(): BelongsToMany
    {
        return $this->belongsToMany(Company::class, 'company_letter_form', 'letter_form_id', 'company_id')
            ->withTimestamps();
    }
}
