<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;

class LetterTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'content',
        'description',
        'user_id',
        'is_public',
        'type',
    ];

    protected $casts = [
        'is_public' => 'boolean',
    ];

    /**
     * ارتباط با کاربر خالق قالب
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * متد کمکی برای دریافت خلاصه محتوا
     */
    public function getExcerpt($length = 100): string
    {
        // حذف تگ‌های HTML و محدود کردن طول متن
        return Str::limit(strip_tags($this->content), $length);
    }

    /**
     * تولید کد منحصر به فرد (اختیاری) در صورت نیاز به کدگذاری داخلی
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($template) {
            if (empty($template->code)) {
                $template->code = 'TMP-' . strtoupper(Str::random(8));
            }
        });
    }
}
