<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany; // اضافه کردن HasMany

class Payee extends Model
{
    protected $fillable = [
        'type',
        'name',
        'national_id',
        'bank_name',
        'account_number',
        'sheba',
        'contact_person',
    ];

    protected $casts = [
        'type' => 'string',
    ];

    /**
     * 💡 رابطه جدید: هر Payee می تواند چندین درخواست وجه داشته باشد.
     */
    public function paymentRequests(): HasMany
    {
        return $this->hasMany(PaymentRequest::class, 'payee_id');
    }
}
