<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PaymentRequestApproval extends Model
{
    protected $fillable = [
        'payment_request_id', 'user_id', 'role_id', 'is_approved',
        'approved_at', 'comment', 'priority',
    ];

    protected $casts = [
        'approved_at' => 'datetime',
        'is_approved' => 'boolean',
        'priority' => 'integer',
    ];

    public function paymentRequest(): BelongsTo
    {
        return $this->belongsTo(PaymentRequest::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function role(): BelongsTo
    {
        return $this->belongsTo(Role::class); // فرض می‌کنیم مدل Role وجود دارد
    }
}
