<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Casts\Attribute; // 💡 برای Accessor


class PaymentRequestAttachment extends Model
{
    protected $fillable = ['payment_request_id', 'file_path', 'original_name', 'mime_type', 'size'];

    public function paymentRequest(): BelongsTo
    {
        return $this->belongsTo(PaymentRequest::class);
    }

    // مسیر کامل برای نمایش
    public function getUrlAttribute()
    {
        return asset('storage/' . $this->file_path);
    }
    public function isImage(): bool
    {
        return in_array($this->mime_type, ['image/jpeg', 'image/png', 'image/gif']);
    }

    public function isPdf(): bool
    {
        return $this->mime_type === 'application/pdf';
    }

    public function getIconAttribute(): string
    {
        // 💡 منطق تعیین آیکون بر اساس MIME Type یا Ext
        $mime = strtolower($this->mime_type);
        if (str_contains($mime, 'image')) {
            return 'ti ti-photo';
        } elseif ($mime === 'application/pdf') {
            return 'ti ti-file-invoice';
        } elseif (str_contains($mime, 'word') || str_contains($mime, 'document')) {
            return 'ti ti-file-text';
        }
        return 'ti ti-file';
    }
}
