<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectContract extends Model
{
    protected $fillable = [
        'project_id',
        'status_id',
        'title',
        'number',
        'description',
        'base_amount',
        'currency_unit',
        'exchange_rate',
        'start_date',
        'end_date',
        'signed_at',
        'contract_type',
        'is_main',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'signed_at' => 'date',
        'base_amount' => 'decimal:2',
        'exchange_rate' => 'decimal:6',
        'is_main' => 'boolean',
    ];

    // Relationships
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function status()
    {
        return $this->belongsTo(ContractStatus::class);
    }

    public function addenda()
    {
        return $this->hasMany(ProjectContractAddendum::class)->orderBy('created_at');
    }

    public function documents()
    {
        return $this->hasMany(ProjectContractDocument::class);
    }

    // Calculated total amount
    public function getTotalAmountAttribute()
    {
        return $this->base_amount + $this->addenda->sum('amount');
    }
}
