<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectContractAddendum extends Model
{

    protected $table = 'project_contract_addenda';


    protected $fillable = [
        'project_contract_id',
        'title',
        'description',
        'amount',
        'currency_unit',
        'exchange_rate',
        'effective_date',
        'approved_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'exchange_rate' => 'decimal:6',
        'effective_date' => 'date',
        'approved_at' => 'date',
    ];

    public function contract()
    {
        return $this->belongsTo(ProjectContract::class, 'project_contract_id');
    }
}
