<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectContractDocument extends Model
{
    protected $fillable = [
        'project_contract_id',
        'uploaded_by',
        'title',
        'file_path',
        'version',
    ];

    public function contract()
    {
        return $this->belongsTo(ProjectContract::class, 'project_contract_id');
    }

    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}
