<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectDetail extends Model
{
    protected $fillable = [
        'project_id',
        'manager_id',
        'project_code',
        'main_client_id',
        'contractor_id',
        'sub_client_id',
        'project',
        'tax_code',
        'status',
    ];


    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function mainClient()
    {
        return $this->belongsTo(Company::class, 'main_client_id');
    }

    public function subClient()
    {
        return $this->belongsTo(Company::class, 'sub_client_id');
    }

    public function contractor()
    {
        return $this->belongsTo(Company::class, 'contractor_id');
    }

    public function manager()
    {
        return $this->belongsTo(User::class, 'manager_id');
    }



}
