<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProjectInsurance extends Model
{
    protected $fillable = [
        'project_id',
        'company_id',
        'start_date',
        'end_date',
        'execution_duration',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function attachments(): HasMany
    {
        return $this->hasMany(InsuranceAttachment::class);
    }
}
