<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProjectPoiWeight extends Model
{
    protected $fillable = ['project_id', 'poi_type', 'weight_percent'];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    // لیست POI Types از DocumentRevision را ارث‌بری می‌کند
    public static function getAvailablePoiTypes()
    {
        return DocumentRevision::POI_TYPES;
    }
}
