<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Livewire\Attributes\Layout;

class ProjectRole extends Model
{
    protected $fillable = [
        'project_id',
        'company_id',
        'role_type', // نوع نقش
    ];

    // رابطه با پروژه
    public function project()
    {
        return $this->belongsTo(Project::class);
    }


    // رابطه با شرکت
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
