<?php
// App\Models\ProjectWallPost.php (تکمیل شده)

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany; // 💡 اضافه شدن use

class ProjectWallPost extends Model
{
    use HasFactory;

    protected $table = 'project_wall_posts';

    protected $fillable = [
        'project_id',
        'user_id',
        'content',
        'type', // status', 'report', 'milestone'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // رابطه با پروژه
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    // رابطه با کاربر (ثبت‌کننده وضعیت)
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    // 🛑 رابطه جدید: پیوست‌ها (Attachments)
    public function attachments(): HasMany
    {
        return $this->hasMany(WallPostAttachment::class);
    }

    public function comments(): HasMany
    {
        return $this->hasMany(WallPostComment::class);
    }

}
