<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PurchaseRequestApproval extends Model
{
    protected $fillable = [
        'purchase_request_id',
        'user_id',
        'role_id',
        'is_approved',
        'approved_at',
        'comment',
        'priority',
    ];

    protected $casts = [
        'approved_at' => 'datetime', // ⬅️ این خط ضروری است!
        'is_approved' => 'boolean',
    ];

    public function purchaseRequest(): BelongsTo
    {
        return $this->belongsTo(PurchaseRequest::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function role(): BelongsTo
    {
        return $this->belongsTo(Role::class);
    }

    public function request()
    {
        return $this->belongsTo(\App\Models\PurchaseRequest::class, 'purchase_request_id');
    }


}
