<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReferralComment extends Model
{
    protected $fillable = [
        'referral_id', 'user_id', 'parent_id', 'body'
    ];

    public function referral()
    {
        return $this->belongsTo(Referral::class);
    }

    public function parent()
    {
        return $this->belongsTo(ReferralComment::class, 'parent_id');
    }

    public function replies()
    {
        return $this->hasMany(ReferralComment::class, 'parent_id')->with('user', 'replies');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}

