<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $fillable = [
        'name',
        'label', // نام نمایشی (مثل 'مدیر سیستم')
        'is_project_role' // برای نقش‌های پروژه‌ای
    ];

//    public function permissions()
//    {
//        return $this->belongsToMany(Permission::class);
//    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'role_permissions');
    }

    public function users()
    {
        // اگر از role_id در جدول users استفاده می‌کنید:
        return $this->hasMany(User::class);
    }

}
