<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute; // 💡 Import Attribute for modern accessors
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SalesInvoiceItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'sales_invoice_id', // 💡 Renamed from sales_invoice_id to match common conventions
        'description',
        'quantity',
        'unit_price',
       'subtotal',
    ];

    // 💡 Casting for precision and type safety
    protected $casts = [
        'quantity' => 'integer',
        'unit_price' => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    // 💡 Accessor to calculate subtotal dynamically (using stored values)
    protected function subtotal(): Attribute
    {
        return Attribute::get(fn () => round($this->quantity * $this->unit_price, 2));
    }

    // Relationship to the SalesInvoice header
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(SalesInvoice::class, 'sales_invoice_id');
    }
}
