<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TaskComment extends Model
{
    protected $fillable = ['task_id', 'user_id', 'body', 'parent_id', 'file_path'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function replies()
    {
        // مرتب‌سازی descending
        return $this->hasMany(TaskComment::class, 'parent_id')->with('user', 'replies')->orderBy('created_at', 'desc');
    }
    public function parent()
    {
        return $this->belongsTo(TaskComment::class, 'parent_id');
    }
    public function views()
    {
        return $this->hasMany(TaskCommentView::class, 'task_comment_id');
    }
}
