<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transmittal extends Model
{
    protected $fillable = [
        'project_id',
        'transmittal_number',
        'subject',
        'sender_id',
        'receiver_id',
        'purpose',
        'status',
        'sent_at',
        'description',
        'attachment_path', // اگر فایل پیوست داری
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function masterDocuments()
    {
        // اگر جدول واسط transmittal_master_document ستون revision_id یا status دارد:
        return $this->belongsToMany(MasterDocument::class, 'transmittal_master_document')
            ->withPivot('revision_id', 'status', 'remark');
    }
    public function documents()
    {
        return $this->hasMany(\App\Models\TransmittalDocument::class);
    }
    public function attachments()
    {
        return $this->hasMany(\App\Models\TransmittalAttachment::class);
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'sender_id');
    }

    public function receiver()
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }

    public function transmittalDocuments()
    {
        return $this->hasMany(TransmittalDocument::class);
    }

    public function recipients()
    {
        return $this->hasMany(\App\Models\TransmittalRecipient::class);
    }
    // اگر فایل پیوست داری
    public function getAttachmentUrlAttribute()
    {
        return $this->attachment_path ? asset('storage/' . $this->attachment_path) : null;
    }

    // نمایش وضعیت به صورت badge رنگی
    public function getStatusBadgeAttribute()
    {
        $map = [
            'ارسال شده' => 'badge bg-info',
            'دریافت شده' => 'badge bg-success',
            'در انتظار' => 'badge bg-warning text-dark',
            'رد شده' => 'badge bg-danger',
        ];
        $class = $map[$this->status] ?? 'badge bg-secondary';
        return "<span class=\"$class\">{$this->status}</span>";
    }

    // تاریخ ارسال با فرمت دلخواه (مثلاً شمسی)
    public function getSentAtFormattedAttribute()
    {
        return $this->sent_at ? jdate($this->sent_at)->format('Y/m/d') : '-';
    }

    public function logs() {
        return $this->hasMany(\App\Models\TransmittalLog::class);
    }

}
