<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransmittalAttachment extends Model
{
    /** @use HasFactory<\Database\Factories\TransmittalAttachmentFactory> */
    use HasFactory;

    protected $fillable = ['transmittal_id', 'file_name', 'file_path', 'size'];

    public function transmittal()
    {
        return $this->belongsTo(Transmittal::class);
    }

    public function getDownloadUrlAttribute()
    {
        return asset('storage/' . $this->file_path);
    }

    public function getFormattedSizeAttribute()
    {
        if ($this->size < 1024) return $this->size . ' B';
        if ($this->size < 1048576) return round($this->size / 1024, 2) . ' KB';
        return round($this->size / 1048576, 2) . ' MB';
    }

}
