<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransmittalDocument extends Model
{
    protected $table = 'transmittal_documents';

    protected $fillable = [
        'transmittal_id',
        'master_document_id',
        'revision_id',
        'revision',
        'description',
    ];

    public function transmittal()
    {
        return $this->belongsTo(Transmittal::class);
    }

    public function masterDocument()
    {
        return $this->belongsTo(MasterDocument::class);
    }

    public function revision()
    {
        return $this->belongsTo(DocumentRevision::class, 'revision_id');
    }
//    public function transmittal()
//    {
//        return $this->belongsTo(\App\Models\Transmittal::class);
//    }
    // تغییر نام تا با ستون 'revision' قاطی نشود
    public function revisionModel()
    {
        return $this->belongsTo(DocumentRevision::class, 'revision_id');
    }

}
