<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TransmittalLog extends Model
{
    protected $fillable = [
        'transmittal_id',
        'user_id',
        'action',
        'description',
        'meta',
    ];

    protected $casts = [
        'meta'       => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function transmittal(): BelongsTo
    {
        return $this->belongsTo(Transmittal::class);
    }

    public function user(): BelongsTo
    {
        // 👈 این رابطه لازم است تا بتوانی logs.user را eager load کنی
        return $this->belongsTo(User::class);
    }
}
