<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Jenssegers\Agent\Agent;

class UserLoginHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'login_at',
        'ip_address',
        'user_agent',
        'metadata',
    ];

    protected $casts = [
        'login_at' => 'datetime',
        'metadata' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // ✅ Accessor برای دستگاه (مرورگر، سیستم‌عامل و ...)
    public function getDeviceAttribute()
    {
        $agent = new Agent();
        $agent->setUserAgent($this->user_agent);

        return [
            'device' => $agent->device() ?: 'Unknown',
            'platform' => $agent->platform() ?: 'Unknown',
            'browser' => $agent->browser() ?: 'Unknown',
            'is_mobile' => $agent->isMobile(),
            'is_desktop' => $agent->isDesktop(),
        ];
    }

    // ✅ Accessor ایمن برای موقعیت جغرافیایی — از metadata استفاده می‌کند
    public function getLocationAttribute()
    {
        // اولویت: اگر موقعیت در metadata ذخیره شده
        if (!empty($this->metadata['geo'])) {
            $geo = $this->metadata['geo'];
            return [
                'country' => $geo['country'] ?? 'Unknown',
                'city' => $geo['city'] ?? 'Unknown',
                'country_code' => strtolower($geo['country_code'] ?? 'xx'),
            ];
        }

        // IP لوکال
        if (in_array($this->ip_address, ['127.0.0.1', '::1', '0.0.0.0'])) {
            return [
                'country' => 'Local',
                'city' => 'localhost',
                'country_code' => 'local'
            ];
        }

        // پیش‌فرض ایمن
        return [
            'country' => 'Unknown',
            'city' => 'Unknown',
            'country_code' => 'xx'
        ];
    }
}
