<?php

// App/Models/WallPostAttachment.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WallPostAttachment extends Model
{
    use HasFactory;

    protected $table = 'wall_post_attachments';

    protected $fillable = [
        'project_wall_post_id',
        'file_path',
        'file_name',
        'file_type',
        'file_size',
    ];

    // رابطه معکوس: پیوست متعلق به کدام پست است
    public function post(): BelongsTo
    {
        return $this->belongsTo(ProjectWallPost::class, 'project_wall_post_id');
    }
}
