<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WallPostComment extends Model
{
    use HasFactory;

    // 💡 نام جدول
    protected $table = 'wall_post_comments';

    protected $fillable = [
        'project_wall_post_id',
        'user_id',
        'content',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * رابطه با پست والد (ProjectWallPost)
     */
    public function post(): BelongsTo
    {
        // 🛑 استفاده از نام کلید خارجی که در Migration تعریف شده است
        return $this->belongsTo(ProjectWallPost::class, 'project_wall_post_id');
    }

    /**
     * رابطه با کاربر کامنت‌گذار
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
